/*
 * Decompiled with CFR 0.152.
 */
package curiousarmorstands;

import curiousarmorstands.ArmorStandCuriosLayer;
import curiousarmorstands.CurioInventoryCapability;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.client.render.CuriosLayer;

@Mod(value="curious_armor_stands")
public class CuriousArmorStands {
    public static final String MODID = "curious_armor_stands";
    public static final String SLOT = "armor_stand_curio";

    @Mod.EventBusSubscriber(modid="curious_armor_stands")
    public static class Events {
        @SubscribeEvent
        public static void entityJoinWorld(EntityJoinWorldEvent event) {
            Entity entity;
            if (!event.getWorld().m_5776_() && (entity = event.getEntity()) instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)entity;
                CuriosApi.getSlotHelper().setSlotsForType(CuriousArmorStands.SLOT, (LivingEntity)armorStand, 8);
            }
        }

        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            Object object = event.getObject();
            if (object instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)object;
                event.addCapability(CuriosCapability.ID_INVENTORY, CurioInventoryCapability.createProvider(armorStand));
            }
        }

        @SubscribeEvent
        public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
            Entity entity = event.getTarget();
            if (entity instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)entity;
                ItemStack stack = event.getItemStack();
                if (!stack.m_41619_()) {
                    Events.equipItem(armorStand, stack, event);
                } else if (Events.canUnequipCurio(event.getLocalPos(), armorStand)) {
                    Events.unequipItem(armorStand, event);
                }
            }
        }

        public static void equipItem(ArmorStand armorStand, ItemStack stack, PlayerInteractEvent.EntityInteractSpecific event) {
            if (CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).isEmpty()) {
                return;
            }
            if (armorStand.f_19853_.m_5776_()) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)armorStand).ifPresent(handler -> handler.getStacksHandler(CuriousArmorStands.SLOT).ifPresent(stacksHandler -> {
                IDynamicStackHandler cosmetics = stacksHandler.getCosmeticStacks();
                Optional curio = CuriosApi.getCuriosHelper().getCurio(stack).resolve();
                for (int slot = 0; slot < cosmetics.getSlots(); ++slot) {
                    SlotContext slotContext = new SlotContext(CuriousArmorStands.SLOT, (LivingEntity)armorStand, slot, true, true);
                    if (!cosmetics.getStackInSlot(slot).m_41619_() || !curio.isEmpty() && !((ICurio)curio.get()).canEquip(slotContext)) continue;
                    cosmetics.setStackInSlot(slot, stack.m_41777_());
                    if (curio.isPresent()) {
                        ((ICurio)curio.get()).playRightClickEquipSound((LivingEntity)armorStand);
                    } else {
                        armorStand.f_19853_.m_5594_(null, armorStand.m_142538_(), SoundEvents.f_11675_, armorStand.m_5720_(), 1.0f, 1.0f);
                    }
                    Events.enableArmorStandArms(armorStand, stack.m_41720_());
                    if (!event.getPlayer().m_7500_()) {
                        int count = stack.m_41613_();
                        stack.m_41774_(count);
                    }
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
            }));
        }

        public static void unequipItem(ArmorStand armorStand, PlayerInteractEvent.EntityInteractSpecific event) {
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)armorStand).ifPresent(handler -> handler.getStacksHandler(CuriousArmorStands.SLOT).ifPresent(stacksHandler -> {
                IDynamicStackHandler cosmetics = stacksHandler.getCosmeticStacks();
                for (int slot = cosmetics.getSlots() - 1; slot >= 0; --slot) {
                    ItemStack stackInSlot = cosmetics.getStackInSlot(slot);
                    if (stackInSlot.m_41619_()) continue;
                    if (!armorStand.f_19853_.m_5776_()) {
                        event.getPlayer().m_21008_(event.getHand(), stackInSlot);
                        cosmetics.setStackInSlot(slot, ItemStack.f_41583_);
                    }
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
            }));
        }

        private static void enableArmorStandArms(ArmorStand entity, Item item) {
            Set tags = CuriosApi.getCuriosHelper().getCurioTags(item);
            if (tags.contains("hands") || tags.contains("ring") || tags.contains("bracelet")) {
                entity.m_31675_(true);
            }
        }

        private static boolean canUnequipCurio(Vec3 localPos, ArmorStand entity) {
            double y;
            boolean isSmall = entity.m_31666_();
            double d = y = isSmall ? localPos.f_82480_ * 2.0 : localPos.f_82480_;
            return !(entity.m_21033_(EquipmentSlot.FEET) && y >= 0.1 && y < 0.1 + (isSmall ? 0.8 : 0.45) || entity.m_21033_(EquipmentSlot.CHEST) && y >= 0.9 + (isSmall ? 0.3 : 0.0) && y < 0.9 + (isSmall ? 1.0 : 0.7) || entity.m_21033_(EquipmentSlot.LEGS) && y >= 0.4 && y < 0.4 + (isSmall ? 1.0 : 0.8) || entity.m_21033_(EquipmentSlot.HEAD) && y >= 1.6 || entity.m_21033_(EquipmentSlot.MAINHAND) || entity.m_21033_(EquipmentSlot.OFFHAND));
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
            EntityRenderer renderer = (EntityRenderer)Minecraft.m_91087_().m_91290_().f_114362_.get(EntityType.f_20529_);
            if (renderer instanceof ArmorStandRenderer) {
                ArmorStandRenderer armorStandRenderer = (ArmorStandRenderer)renderer;
                armorStandRenderer.m_115326_((RenderLayer)new CuriosLayer((RenderLayerParent)armorStandRenderer));
                armorStandRenderer.m_115326_(new ArmorStandCuriosLayer(armorStandRenderer));
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void enqueueIMC(InterModEnqueueEvent event) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(CuriousArmorStands.SLOT).cosmetic().size(0).build());
        }
    }
}

